/*
This application dumps the relevent parts of a user's directory listing to the console. 
syntax:
GetEntry <UserID>
*/



import cnrg.itx.ds.*;
class GetEntry {
	public static void  main(String args[]) {
		if (args.length <1) {
			System.out.println("Specify a userID");
			System.exit(1);
		}
		DirectoryService d = null;
		try {
			d = new DirectoryService();
			d.setCleanUp(false);
			d.declareIdentity(new UserID("guest"), new Password("guest"));
			
			LocationList ll = d.getLocationListByID(new UserID(args[0]));
			if (ll.count() > 0) {
				Location l = ll.first();
				do{
					System.out.println(l.getIP()+":"+l.getPort()+" Type: "+l.getType()+", "+
									   (l.isDialable()?"is dialable":"is not dialable")+", label:"+l.getLabel());
				}while ((l=ll.next()) != null);
			}else System.out.println("No listings for "+args[0]);	
		} catch (Throwable t) {
			t.printStackTrace();
		}
	}
}